local ItemDist = {
    {
      Distributions = {
        {"BakeryKitchenFridge", 8},
        {"CafeKitchenFridge", 8},
        {"CrepeKitchenFridge", 8},
        {"CrepeKitchenSauce", 8},
        {"GigamartSauce", 8},
        {"KitchenBreakfast", 8},
      },
      Items = {
        "ClosedLemonJam",
        "ClosedOrangeJam",
        "ClosedAppleJam",
        "ClosedBananaJam",
        "ClosedPeachJam",
        "ClosedPineappleJam",
        "ClosedCherryJam",
        "ClosedGrapesJam",
        "ClosedPearJam",
        "ClosedMangoJam",
        "ClosedWatermelonJam",
      }
    },
}
  
  
  
local function getLootTable(strLootTableName)
    return ProceduralDistributions.list[strLootTableName]
end
  
local function insertItem(tLootTable, strItem, iWeight)
    table.insert(tLootTable.items, strItem)
    table.insert(tLootTable.items, iWeight)
end
  
local function preDistributionMerge()
    for i=1, #ItemDist do
      for j=1, #(ItemDist[i].Distributions) do
        for k=1, #(ItemDist[i].Items) do
          local tLootTable = getLootTable(ItemDist[i].Distributions[j][1])
          local strItem = ItemDist[i].Items[k]
          local iWeight = ItemDist[i].Distributions[j][2]
          insertItem(tLootTable, strItem, iWeight)
        end
      end
    end
end
Events.OnPreDistributionMerge.Add(preDistributionMerge)